package inc.monsters.mias.data.statistics;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import org.apache.myfaces.trinidad.model.ChartModel;

public class XYData extends ChartModel {
	private static final Logger log = Logger.getLogger("inc.monsters.mias");
	private List<List<Double>> xData;
	private List<List<Double>> yData;

	private void calculate() {
		log.fine("calculate()");
		if (null == xData || null == yData) {
			xData = new ArrayList<List<Double>>();
			yData = new ArrayList<List<Double>>();
			
			for(int i = 0; i < 10; i++){ 
				xData.add(new ArrayList<Double>());
				xData.get(i).add(Math.random() * 10.0);
				xData.get(i).add(Math.random() * 10.0);
				yData.add(new ArrayList<Double>());
				yData.get(i).add(Math.random() * 10.0);
				yData.get(i).add(Math.random() * 10.0);
			}
		
			log.fine("X data size: " + xData.size());
			for(List<Double> list : xData) {
				log.finer(" => " + list);
			}
			log.fine("Y data size: " + yData.size());
			for(List<Double> list : yData) {
				log.finer(" => " + list);
			}
		}
	}
	
	@Override
	public List<String> getGroupLabels() {
		log.fine("getGroupLabels()");
		calculate();
		List<String> x = new ArrayList<String>();
		return x;
	}

	@Override
	public List<String> getSeriesLabels() {
		log.fine("getSeriesLabels()");
		calculate();
		List<String> x = new ArrayList<String>();
		x.add("Series 1");
		x.add("Series 2");
		return x;
	}

	@Override
	public List<List<Double>> getYValues() {
		log.fine("getYValues()");
		calculate();
		return yData;
	}
	
	@Override
	public List<List<Double>> getXValues() {
		log.fine("getXValues()");
		calculate();
		return xData;
	}

	@Override
	public String getFootNote() {
		return super.getFootNote();
	}

	@Override
	public Double getMaxXValue() {
		return 10.0;
	}

	@Override
	public Double getMaxYValue() {
		return 10.0;
	}

	@Override
	public Double getMinXValue() {
		return 0.0;
	}

	@Override
	public Double getMinYValue() {
		return 0.0;
	}

	@Override
	public List<Color> getSeriesColors() {
		return super.getSeriesColors();
	}

	@Override
	public String getSubTitle() {
		return super.getSubTitle();
	}

	@Override
	public String getTitle() {
		return "XY data";
	}

}